/*
 * Decompiled with CFR 0.152.
 */
package io.github.cat24a.klowenia_tales.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.ScreenUtils;
import io.github.cat24a.klowenia_tales.Item;
import io.github.cat24a.klowenia_tales.Main;
import io.github.cat24a.klowenia_tales.scene.PreDrawer;
import io.github.cat24a.klowenia_tales.scene.Scene;
import io.github.cat24a.klowenia_tales.util.Direction;
import io.github.cat24a.klowenia_tales.util.GraphicsUtil;
import io.github.cat24a.klowenia_tales.util.Hash;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class World
implements Scene {
    public static final float PLAYER_SPEED = 80.0f;
    Vector2 playerPosition = new Vector2(0.0f, 0.0f);
    Direction playerDirection = Direction.DOWN;
    Vector2 playerMovement = new Vector2();
    int roomx = 0;
    int roomy = 0;
    int seed = 0;
    Set<Long> unlockedDoors = new HashSet<Long>();
    Set<Long> takenKeys = new HashSet<Long>();
    Set<Long> activeGoldPlates = new HashSet<Long>();
    int takenKeyCount = 0;
    boolean goldPlateActive = false;
    public static final int HALF_ROOM_SIZE = 29;
    Item[] inventory = new Item[8];
    boolean door_was_open = false;

    @Override
    public void draw(Main game) {
        float delta = Gdx.graphics.getDeltaTime();
        this.playerMovement.x = (Gdx.input.isKeyPressed(22) ? 1 : 0) - (Gdx.input.isKeyPressed(21) ? 1 : 0);
        this.playerMovement.y = (Gdx.input.isKeyPressed(19) ? 1 : 0) - (Gdx.input.isKeyPressed(20) ? 1 : 0);
        this.playerMovement.setLength(80.0f * delta);
        this.playerPosition.add(this.playerMovement);
        this.playerPosition.x = MathUtils.clamp(this.playerPosition.x, -29.0f, 29.0f);
        this.playerPosition.y = MathUtils.clamp(this.playerPosition.y, -29.0f, 29.0f);
        this.playerDirection = Direction.of(this.playerMovement).orElse(this.playerDirection);
        if (this.goldPlateActive) {
            this.playerMovement.set(0.0f, 0.0f);
            this.playerPosition.set(0.0f, 0.0f);
        }
        Map<Direction, Boolean> doors = World.getDoors(this.roomx, this.roomy, this.seed);
        long packedRoomCoordinates = Hash.roomHash(this.roomx, this.roomy);
        boolean doorsUnlocked = this.unlockedDoors.contains(packedRoomCoordinates);
        ScreenUtils.clear(0.05f, 0.05f, 0.05f, 1.0f);
        GraphicsUtil.drawCentered(game, game.assets.ROOM, 0.0f, 0.0f);
        boolean hasDrawers = false;
        boolean door_is_open = false;
        boolean hasGoldLock = false;
        for (Direction dir : Direction.values()) {
            boolean door = doors.get((Object)dir);
            TextureRegion texture = (door ? game.assets.DOOR : game.assets.NO_DOOR).get((Object)dir);
            GraphicsUtil.drawCentered(game, texture, dir.unit.x * 42.0f, dir.unit.y * 42.0f);
            if (!door) continue;
            boolean near = this.playerPosition.dst2(dir.unit.cpy().scl(42.0f)) < 400.0f;
            boolean locked = World.numberOfDoors(this.roomx + (int)dir.unit.x, this.roomy + (int)dir.unit.y, this.seed) == 1;
            boolean gold = Hash.probabilityHash(this.roomx + (int)dir.unit.x, this.roomy + (int)dir.unit.y, this.seed, 2, 0.3f);
            if (locked && !gold) {
                hasDrawers = true;
            }
            if (doorsUnlocked && !gold) {
                locked = false;
            }
            if (near && !locked) {
                door_is_open = true;
            }
            if (locked && gold) {
                hasGoldLock = true;
            }
            GraphicsUtil.drawCentered(game, near && !locked ? game.assets.DOOR_OPEN : game.assets.DOOR_CLOSED, dir.unit.x * 42.0f, dir.unit.y * 42.0f);
            if (locked) {
                GraphicsUtil.drawCentered(game, gold ? game.assets.LOCK_GOLD : game.assets.LOCK, dir.unit.x * 42.0f, dir.unit.y * 42.0f);
                continue;
            }
            float posIntoAxis = dir.unit.dot(this.playerPosition);
            float posCrossAxis = dir.unit.crs(this.playerPosition);
            float moveIntoAxis = dir.unit.dot(this.playerMovement);
            float moveCrossAxis = dir.unit.crs(this.playerMovement);
            if (posIntoAxis != 29.0f || !(Math.abs(posCrossAxis) < 8.0f) || !(moveIntoAxis > 0.0f) || moveCrossAxis != 0.0f) continue;
            this.playerPosition.set(dir.unit);
            this.playerPosition.scl(-29.0f);
            this.roomx = (int)((float)this.roomx + dir.unit.x);
            this.roomy = (int)((float)this.roomy + dir.unit.y);
            System.out.println("X: " + this.roomx + "   Y: " + this.roomy);
        }
        if (door_is_open && !this.door_was_open) {
            game.assets.DOOR_OPEN_SOUND.play();
        }
        if (!door_is_open && this.door_was_open) {
            game.assets.DOOR_CLOSE_SOUND.play();
        }
        this.door_was_open = door_is_open;
        int keyDrawer = Math.floorMod((int)Hash.hash(this.roomx, this.roomy, this.seed, 3), 4);
        Vector2 drawerPosition = new Vector2(28.0f, 28.0f);
        if (hasDrawers) {
            for (int i = 0; i < 4; ++i) {
                GraphicsUtil.drawCentered(game, game.assets.DRAWER, drawerPosition.x, drawerPosition.y);
                if (drawerPosition.dst2(this.playerPosition) < 121.0f) {
                    GraphicsUtil.drawCentered(game, game.assets.PRESS_E_INDICATOR, drawerPosition.x, drawerPosition.y);
                    if (Gdx.input.isKeyJustPressed(33)) {
                        game.scene = new PreDrawer(this, i == keyDrawer && !doorsUnlocked);
                    }
                }
                drawerPosition.rotate90(1);
            }
        }
        if (hasGoldLock) {
            GraphicsUtil.drawCentered(game, game.assets.GOLDEN_PLATE, 0.0f, 0.0f);
            if (this.playerPosition.dst2(0.0f, 0.0f) < 121.0f && (this.takenKeyCount >= 8 || this.activeGoldPlates.contains(packedRoomCoordinates))) {
                GraphicsUtil.drawCentered(game, game.assets.PRESS_E_INDICATOR, 0.0f, 12.0f);
                if (Gdx.input.isKeyJustPressed(33)) {
                    if (this.activeGoldPlates.contains(packedRoomCoordinates)) {
                        this.goldPlateActive = true;
                    } else {
                        this.takenKeyCount -= 8;
                        this.activeGoldPlates.add(packedRoomCoordinates);
                    }
                }
            }
        }
        if (Hash.probabilityHash(this.roomx, this.roomy, this.seed, 4, 0.1f) && !this.takenKeys.contains(packedRoomCoordinates)) {
            GraphicsUtil.drawCentered(game, game.assets.COLORED_KEY, 0.5f, 0.0f);
            if (this.playerPosition.dst2(0.0f, 0.0f) < 121.0f) {
                GraphicsUtil.drawCentered(game, game.assets.PRESS_E_INDICATOR, 0.0f, 0.0f);
                if (Gdx.input.isKeyJustPressed(33)) {
                    this.takenKeys.add(packedRoomCoordinates);
                    ++this.takenKeyCount;
                    System.out.println(this.takenKeyCount + " keys.");
                }
            }
        }
        GraphicsUtil.drawCentered(game, game.assets.PLAYER1.get((Object)this.playerDirection), this.playerPosition.x, this.playerPosition.y);
        GraphicsUtil.drawCentered(game, game.assets.HUD, 0.0f, -60.0f);
        float[] itemx = new float[]{-57.0f, -43.0f, -29.0f, -16.0f, 16.0f, 29.0f, 43.0f, 57.0f};
        for (int i = 0; i < 8; ++i) {
            GraphicsUtil.drawCentered(game, Item.getTexture(game, this.inventory[i]), itemx[i], -66.0f);
        }
    }

    public static Map<Direction, Boolean> getDoors(int roomx, int roomy, int seed) {
        return Map.of(Direction.UP, Hash.probabilityHash(roomx, roomy, seed, 1, 0.5), Direction.DOWN, Hash.probabilityHash(roomx, roomy - 1, seed, 1, 0.5), Direction.RIGHT, Hash.probabilityHash(roomx, roomy, seed, 0, 0.5), Direction.LEFT, Hash.probabilityHash(roomx - 1, roomy, seed, 0, 0.5));
    }

    public static int numberOfDoors(int roomx, int roomy, int seed) {
        int doors = 0;
        for (boolean door : World.getDoors(roomx, roomy, seed).values()) {
            if (!door) continue;
            ++doors;
        }
        return doors;
    }
}

